/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.helptools;

import com.ibm.hwmca.fw.util.Trace;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;

class HelpILog
implements ILog {
    private static final String TRACE_MASKT = "HELPAPPT";
    private static final String TRACE_MASKF = "HELPAPPF";
    private static final String TRACE_MASKD = "HELPAPPD";
    Plugin plugin;
    private static ILog singleton;

    HelpILog(Plugin plugin) {
        this.plugin = plugin;
        singleton = this;
    }

    public static ILog getLogger() {
        return singleton;
    }

    public void addLogListener(ILogListener listener) {
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void log(IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.traceStatus(children[i]);
                ++i;
            }
        } else {
            this.traceStatus(status);
        }
    }

    private void traceStatus(IStatus status) {
        String mask;
        int severity = status.getSeverity();
        StringBuffer msg = new StringBuffer();
        msg.append("Help web app ");
        if (severity == 4) {
            mask = TRACE_MASKT;
            msg.append("error: ");
        } else if (severity == 2) {
            mask = TRACE_MASKF;
            msg.append("warning: ");
        } else if (severity == 1 || severity == 0) {
            mask = TRACE_MASKD;
            msg.append(severity == 1 ? "info: " : "ok: ");
        } else {
            mask = TRACE_MASKT;
            msg.append("UNKNOWN SEVERITY: ");
        }
        msg.append("Code=");
        msg.append(status.getCode());
        msg.append(", ");
        msg.append(status.getMessage());
        Trace.trace(mask, msg.toString());
        Throwable excp = status.getException();
        if (excp != null) {
            Trace.trace(mask, excp);
        }
    }

    public void removeLogListener(ILogListener listener) {
    }
}

